﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.SessionState;

//
using DotNet.FrameWork.Common.Encrypt;

namespace HteamDd.Web.ashx
{
    /// <summary>
    /// Dd_userExit 的摘要说明
    /// </summary>
    public class Dd_userExit : IHttpHandler,IRequiresSessionState
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";          
            if (context.Request.Params["type"] == "login")
            {
                string userID = context.Request.Params["user_ID"].ToString();
                string nick = context.Request.Params["user_Name"].ToString();
                string email = context.Request.Params["user_Email"].ToString();
                string state = context.Request.Params["user_check"].ToString();
                HttpCookie hc = new HttpCookie("login");
                hc.Values.Add("user_ID_org",userID);
                hc.Values.Add("user_ID",Encrypt.EncryptPassword(userID,"MD5"));
                if (state == "true")
                {
                    hc.Expires = DateTime.Now.AddDays(7);
                    context.Response.Cookies.Add(hc);
                }            
                context.Session["user_Message"] = userID + "," + nick + "," + email;
                context.Response.Write("1");
            }
            else if (context.Request.Params["type"] == "exit")
            {
                if (context.Request.Cookies["login"] != null)
                {
                    HttpCookie hc = context.Request.Cookies["login"];
                    hc.Value = null;
                    context.Response.Cookies.Add(hc);                  
                }
                context.Session.Clear();
                context.Response.Write("1");
            }
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}